s          Q                                             kei197a     Keithley 197a Autoranging Microvolt DMM           
       Keithley 197a Autoranging Microvolt DMM

 This instrument module provides GPIB programming
 support  for  the Keithley 197a DMM.  The
 module is divided into the following functions:

 (1) Initialize
     Initialize the 196 on the  GPIB.

 (2) Configure
     Setup  parameters such as range, relative mode, 
     trigger mode and dB mode.

 (3) Send Trigger
     Sends the appropriate trigger to the instrument.

 (4) Query all Functions
     Reports the state of:
         Measuring Function
         Range
         Relative Mode
         Trigger Mode

 (5) Measure
     Read a single measurement value from the
     meter.
 
 (6) Close
     Take the 197a offline from the GPIB.

     This driver does not currently ake use of the 
     data logger functions in the 197a.
        
                   INITIALIZE

 Initializes  the 197a in  the  following ways:

   - clears the instrument with a GPIB device
     clear

   - sets the instrument to a known state based
     on the factory default settings.

   - queries for the ID of the instrument

   - reads the measuring function that is selected
     on the front panel

   - checks to see if the dB mode is enabled            
             Query Measurement Function

     - Returns the value of the measurement 
       function currently being performed
       in both a string and DDC code format

   
                         
                   Set dB Mode

       - Enables or disables dB Mode 

       NOTE: The instrument must already be set
       in VOLTS (AC or DC) mode on the front panel.
         
                Set Measurement Range

     - Selects the appropriate measurement range 
       based on the parameter "range"

       NOTE: Current ranges are NOT programmable 
       over the GPIB on the 197a.
         
                  Set Relative Mode

        -  Enables or disables relative mode.

        -  Baseline suppression value is acquired
           when command is sent.
     V    
                  Set Trigger Mode

    - Sets the appropriate trigger mode.


         o    
                  Send Trigger

  -     Sends Group Execute Trigger (GET) or the
        the character 'X' 
        
                 Query All Functions

      Returns the state of the following by 
      reading the status word of the 197a:

            - measuring function (and dB mode)
            - measurement range
            - trigger mode
            - relative mode

      The states are reported in both the DDC code
      and an easy-to-read string format.

      This also makes the driver aware of any
      front-panel commands that have affected
      the four parameters listed above.

              _            
                       Measure

      Triggers a measurement and reports a reading.
         
                      CLOSE

 Clears the multimeter, places it in  local mode,
 and takes it off-line.

 The  instrument must be reinitialized to use it
 again.         
 The GPIB ADDRESS control determines what address
 on the GPIB will be used to communicate with the
 instrument.  This value must  correspond  to the
 current internal setting of the device.

 Variable Type : Integer

 Valid Range : 0 to 30    |    
    Error              Description
 ------------------------------------------------
       0     Success
      -1     GPIB Address out of range

     220     Unable to open instrument
     223     Instrument is not a Keithley 197a
     230     GPIB write error
     231     GPIB read error
     233     Unable to configure GPIB address
     236     Unable to clear instrument
     f $           GPIB Address                      
          Error                            
                                             
                                            20            kei197a_err    KNOTE: Set measuring function on front panel before sending init() command.    ZIf the measurement function is changed later, the init() function must be executed again.  y          Function Name                    &                                           8                                           l                                           (          Function Code                             Error                              	            KNOTE: The measurement function is only programmable from the front panel.     PThis function will only retrieve the measurement function from the instrument.     6Press Shift+F5 to execute this operation immediately.    	                    kei197a_err  6 7           Enable                                   Error                              On 1 Off 0            kei197a_err  $           Range                                    Error                            (                                           8                                             0.0            kei197a_err    3Value should be in Volts or Ohms. (0 = Auto Range)    DNOTE: Current ranges are NOT programmable over the bus on the 197a.  P D           Enable                                   Error                              On 1 Off 0            kei197a_err !         Error                            G           Trigger Mode                               kei197a_err               pContinuous on Talk 0 One-Shot on Talk 1 Continuous on GET 2 One-Shot on GET 3 Continuous on X 4 One-Shot on X 5        
 The TRIGGER control specifes a trigger to be
 sent to the multimeter.

 Variable Type : Integer

 Valid Range:  0 - No action
               1 - Send Group Execute Trigger
               2 - Send the character X        
    Error              Description
 ------------------------------------------------
       0     Success/Read Complete/Buffer full
      -1     Clear out of range
      -2     Trigger out of range
      -3     Status out of range

     230     GPIB write error
     231     GPIB read error
     232     Instrument not initialized
     235     Unable to trigger instrument
     236     Unable to clear instrument

     300     Read not complete/Buffer not full     6 y           Trigger                                     Error                                          No Action 0 Send GET 1 Send X 2            kei197a_err  ,           Function Name                    q           Function Code                    +          Range                            *         Relative Mode                    (         Trigger Mode                     o           Range Code                       p
          Relative Mode Code               o          Trigger Code                             Error                              	            	            	            	            	            	            	            	                    kei197a_err  $           Measurement                              Error                              	                   kei197a_err        
    Error              Description
 ------------------------------------------------
       0     Success

     221     Unable to close instrument
     232     Instrument not initialized
     234     Unable to place instrument in local
             mode    U          Error                                      kei197a_err                 K.    init                              &         :     K.    queryMeasurementFunction                        K.    setdBMode                                       K.    setMeasurementRange                             K.    setRelativeMode                   <              K.    setTriggerMode                                  K.    sendTrigger                       	         t 	    K.    queryAllFunctions                 
              K.    measure                           t         ]     K.    close                                                                       DInitialize                        Configure                            DQuery Measurement Function           DSet dB Mode                          DSet Measurement Range                DSet Relative Mode                    DSet Trigger Mode                     DSend Trigger                         DQuery All Functions                  DMeasure                              DClose                           